<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';

$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT pay.*, i.amount_due, i.amount_paid, t.name AS tenant_name, t.phone, t.email FROM payments pay 
LEFT JOIN invoices i ON i.id=pay.invoice_id
LEFT JOIN tenants t ON t.id=i.tenant_id
WHERE pay.id=? LIMIT 1");
$st->execute([$id]);
$p = $st->fetch();
if(!$p){ echo 'Receipt not found'; exit; }

$settings = $pdo->query("SELECT `key`,`value` FROM settings")->fetchAll();
$map=[]; foreach($settings as $s){ $map[$s['key']]=$s['value']; }
$logo = $map['logo_url'] ?? '';
$biz = $map['business_name'] ?? 'Business';
$addr = $map['business_address'] ?? '';
$phone = $map['business_phone'] ?? '';
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Receipt #<?= e($p['id']) ?></title>
<style>
  body{font-family:Arial,Helvetica,sans-serif;margin:24px}
  .top{display:flex;justify-content:space-between;align-items:center}
  .muted{color:#6b7280}
  table{width:100%;border-collapse:collapse;margin-top:16px}
  th,td{border:1px solid #e5e7eb;padding:8px;text-align:left}
  .print{position:fixed;right:24px;top:24px;padding:8px 12px;background:#0ea5e9;color:#fff;border:none;border-radius:8px;cursor:pointer}
</style></head><body>
<button class="print" onclick="window.print()">Print</button>
<div class="top">
  <div>
    <h2><?= e($biz) ?></h2>
    <div class="muted"><?= e($addr) ?></div>
    <div class="muted">Phone: <?= e($phone) ?></div>
  </div>
  <div><?php if($logo): ?><img src="<?= e($logo) ?>" alt="logo" style="max-height:70px"><?php endif; ?></div>
</div>
<hr>
<h3>Payment Receipt #<?= e($p['id']) ?></h3>
<div>Tenant: <strong><?= e($p['tenant_name']) ?></strong> — <?= e($p['email']) ?> / <?= e($p['phone']) ?></div>
<table>
  <tr><th>Invoice</th><td>#<?= e($p['invoice_id']) ?></td></tr>
  <tr><th>Amount</th><td><?= number_format($p['amount'],2) ?> KES</td></tr>
  <tr><th>Paid At</th><td><?= e($p['paid_at']) ?></td></tr>
  <tr><th>Method</th><td><?= e($p['method']) ?></td></tr>
  <tr><th>Reference</th><td><?= e($p['ref']) ?></td></tr>
</table>
</body></html>
